<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Check if file was uploaded
if (!isset($_FILES['pdf']) || $_FILES['pdf']['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    echo json_encode(['error' => 'No file uploaded or upload error']);
    exit;
}

$file = $_FILES['pdf'];

// Validate file type
if ($file['type'] !== 'application/pdf') {
    http_response_code(400);
    echo json_encode(['error' => 'Only PDF files are allowed']);
    exit;
}

// Validate file size (50MB limit)
if ($file['size'] > 50 * 1024 * 1024) {
    http_response_code(400);
    echo json_encode(['error' => 'File size must be less than 50MB']);
    exit;
}

// Create uploads directory if it doesn't exist
$uploadDir = '../uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Generate safe filename
$originalName = pathinfo($file['name'], PATHINFO_FILENAME);
$extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$safeFilename = preg_replace('/[^a-zA-Z0-9\-_\.]/', '_', $originalName);
$filename = $safeFilename . '.' . $extension;

// Handle duplicate filenames
$counter = 1;
$finalFilename = $filename;
while (file_exists($uploadDir . $finalFilename)) {
    $finalFilename = $safeFilename . '_' . $counter . '.' . $extension;
    $counter++;
}

// Move uploaded file
if (move_uploaded_file($file['tmp_name'], $uploadDir . $finalFilename)) {
    // Success response
    echo json_encode([
        'success' => true,
        'message' => 'File uploaded successfully',
        'filename' => $finalFilename,
        'size' => $file['size'],
        'originalName' => $file['name']
    ]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to save uploaded file']);
}
?>
