<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FlipBook Magazine - Enhanced Edition</title>
    <meta name="description" content="Experience your PDF magazines as realistic flipbooks with 3D page-turning animations">
    
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="assets/css/flipbook.css">
    <link rel="stylesheet" href="assets/css/style.css">
    
    <!-- PDF.js Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    
    <!-- Turn.js Library for Flipbook Effect -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="assets/js/turn.min.js"></script>
</head>
<body>
    <div id="app">
        <!-- Loading Screen -->
        <div id="loading-screen" class="loading-screen">
            <div class="loading-spinner"></div>
            <p>Loading FlipBook Magazine...</p>
        </div>

        <!-- Main Application -->
        <div id="main-app" class="main-app" style="display: none;">
            <!-- Header -->
            <header class="header">
                <div class="container">
                    <div class="header-content">
                        <div class="logo">
                            <div class="logo-icon">📖</div>
                            <div class="logo-text">
                                <h1>FlipBook Magazine</h1>
                                <p>Enhanced Edition</p>
                            </div>
                        </div>
                        <nav class="header-nav">
                            <button id="upload-btn" class="btn btn-primary">
                                <span>📤</span> Upload Magazine
                            </button>
                            <button id="library-btn" class="btn btn-secondary">
                                <span>📚</span> Library
                            </button>
                        </nav>
                    </div>
                </div>
            </header>

            <!-- Magazine Library View -->
            <div id="library-view" class="library-view">
                <div class="container">
                    <div class="library-header">
                        <h2>Your Magazine Library</h2>
                        <div class="library-controls">
                            <input type="text" id="search-input" placeholder="Search magazines..." class="search-input">
                            <select id="sort-select" class="sort-select">
                                <option value="newest">Newest First</option>
                                <option value="oldest">Oldest First</option>
                                <option value="title">Title A-Z</option>
                                <option value="size">File Size</option>
                            </select>
                        </div>
                    </div>

                    <div id="magazine-grid" class="magazine-grid">
                        <!-- Magazines will be loaded here -->
                    </div>

                    <div id="empty-library" class="empty-library" style="display: none;">
                        <div class="empty-icon">📚</div>
                        <h3>No magazines yet</h3>
                        <p>Upload your first PDF magazine to experience the flipbook magic!</p>
                        <button class="btn btn-primary" onclick="showUploadModal()">
                            <span>📤</span> Upload Your First Magazine
                        </button>
                    </div>
                </div>
            </div>

            <!-- Flipbook Reader View -->
            <div id="reader-view" class="reader-view" style="display: none;">
                <div class="reader-header">
                    <div class="reader-controls-left">
                        <button id="back-to-library" class="btn btn-secondary">
                            <span>←</span> Back to Library
                        </button>
                    </div>
                    <div class="reader-title">
                        <h2 id="current-magazine-title">Magazine Title</h2>
                        <p id="current-magazine-info">Loading...</p>
                    </div>
                    <div class="reader-controls-right">
                        <button id="zoom-out" class="btn btn-secondary" title="Zoom Out">🔍-</button>
                        <button id="zoom-in" class="btn btn-secondary" title="Zoom In">🔍+</button>
                        <button id="fullscreen-btn" class="btn btn-secondary" title="Fullscreen">⛶</button>
                        <button id="download-pdf" class="btn btn-primary" title="Download PDF">📥</button>
                    </div>
                </div>

                <div class="flipbook-container">
                    <div id="flipbook" class="flipbook">
                        <!-- Pages will be loaded here -->
                    </div>
                </div>

                <div class="reader-footer">
                    <div class="page-controls">
                        <button id="first-page" class="btn btn-secondary" title="First Page">⏮</button>
                        <button id="prev-page" class="btn btn-secondary" title="Previous Page">◀</button>
                        <span id="page-info" class="page-info">Page 1 of 1</span>
                        <button id="next-page" class="btn btn-primary" title="Next Page">▶</button>
                        <button id="last-page" class="btn btn-secondary" title="Last Page">⏭</button>
                    </div>
                    <div class="reader-options">
                        <label class="checkbox-label">
                            <input type="checkbox" id="auto-flip" checked>
                            <span>Auto-flip pages</span>
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" id="page-sounds">
                            <span>Page-turn sounds</span>
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upload Modal -->
        <div id="upload-modal" class="modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h3>Upload PDF Magazine</h3>
                    <button id="close-modal" class="close-btn">&times;</button>
                </div>
                <div class="modal-body">
                    <div id="upload-area" class="upload-area">
                        <div class="upload-icon">📄</div>
                        <h4>Drop your PDF magazine here</h4>
                        <p>or click to select a file</p>
                        <input type="file" id="pdf-input" accept=".pdf" style="display: none;">
                        <button type="button" class="btn btn-primary" onclick="document.getElementById('pdf-input').click()">
                            Choose PDF File
                        </button>
                        <div class="upload-info">
                            <small>Supported: PDF files up to 50MB</small>
                        </div>
                    </div>
                    
                    <div id="upload-progress" class="upload-progress" style="display: none;">
                        <div class="progress-header">
                            <h4>Processing Your Magazine</h4>
                            <p id="progress-status">Uploading...</p>
                        </div>
                        <div class="progress-bar">
                            <div id="progress-fill" class="progress-fill"></div>
                        </div>
                        <div class="progress-steps">
                            <div class="step active" id="step-upload">📤 Upload</div>
                            <div class="step" id="step-process">⚙️ Process</div>
                            <div class="step" id="step-convert">🔄 Convert</div>
                            <div class="step" id="step-complete">✅ Complete</div>
                        </div>
                    </div>

                    <div id="upload-result" class="upload-result" style="display: none;">
                        <!-- Upload result will be shown here -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Toast Notifications -->
        <div id="toast-container" class="toast-container"></div>
    </div>

    <!-- JavaScript -->
    <script src="assets/js/pdf-processor.js"></script>
    <script src="assets/js/flipbook-reader.js"></script>
    <script src="assets/js/app.js"></script>

    <script>
        // Initialize the application
        document.addEventListener('DOMContentLoaded', function() {
            // Set PDF.js worker
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
            
            // Initialize the app
            window.flipbookApp = new FlipBookApp();
            
            // Hide loading screen
            setTimeout(() => {
                document.getElementById('loading-screen').style.display = 'none';
                document.getElementById('main-app').style.display = 'block';
            }, 1500);
        });
    </script>
</body>
</html>

<?php
// Get available magazines from multiple possible upload directories
function getMagazines() {
    $magazines = [];
    $uploadDirs = [
        'uploads/',
        '../flipbook-simple/uploads/',
        '../uploads/'
    ];
    
    foreach ($uploadDirs as $uploadDir) {
        if (is_dir($uploadDir)) {
            $files = scandir($uploadDir);
            foreach ($files as $file) {
                if (pathinfo($file, PATHINFO_EXTENSION) === 'pdf') {
                    $filePath = $uploadDir . $file;
                    $magazines[] = [
                        'id' => md5($filePath),
                        'filename' => $file,
                        'filepath' => $filePath,
                        'title' => pathinfo($file, PATHINFO_FILENAME),
                        'size' => filesize($filePath),
                        'date' => filemtime($filePath),
                        'pages' => 0 // Will be calculated when opened
                    ];
                }
            }
        }
    }
    
    // Remove duplicates based on filename
    $uniqueMagazines = [];
    $seenFiles = [];
    foreach ($magazines as $magazine) {
        if (!in_array($magazine['filename'], $seenFiles)) {
            $uniqueMagazines[] = $magazine;
            $seenFiles[] = $magazine['filename'];
        }
    }
    
    // Sort by date (newest first)
    usort($uniqueMagazines, function($a, $b) {
        return $b['date'] - $a['date'];
    });
    
    return $uniqueMagazines;
}

// Output magazines as JSON for JavaScript
if (isset($_GET['api']) && $_GET['api'] === 'magazines') {
    header('Content-Type: application/json');
    echo json_encode(['magazines' => getMagazines()]);
    exit;
}
?>
