<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FlipBook Magazine - Simple Version</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container">
        <header class="header">
            <div class="logo">
                <div class="logo-icon">📖</div>
                <div>
                    <h1>FlipBook Magazine</h1>
                    <p>Simple PDF Upload System</p>
                </div>
            </div>
        </header>

        <?php
        // Simple file listing
        $uploadDir = 'uploads/';
        $magazines = [];
        
        if (is_dir($uploadDir)) {
            $files = scandir($uploadDir);
            foreach ($files as $file) {
                if (pathinfo($file, PATHINFO_EXTENSION) === 'pdf') {
                    $magazines[] = [
                        'name' => $file,
                        'title' => pathinfo($file, PATHINFO_FILENAME),
                        'size' => filesize($uploadDir . $file),
                        'date' => filemtime($uploadDir . $file)
                    ];
                }
            }
        }
        ?>

        <div class="upload-section">
            <h2>Upload PDF Magazine</h2>
            
            <?php if (isset($_POST['upload']) && isset($_FILES['pdf'])): ?>
                <?php
                $uploadFile = $uploadDir . basename($_FILES['pdf']['name']);
                if (move_uploaded_file($_FILES['pdf']['tmp_name'], $uploadFile)) {
                    echo '<div class="success">✅ File uploaded successfully!</div>';
                    // Refresh the page to show new file
                    header('Location: ' . $_SERVER['PHP_SELF']);
                    exit;
                } else {
                    echo '<div class="error">❌ Upload failed!</div>';
                }
                ?>
            <?php endif; ?>

            <form method="post" enctype="multipart/form-data" class="upload-form">
                <div class="upload-area">
                    <div class="upload-icon">📄</div>
                    <h3>Select PDF Magazine</h3>
                    <input type="file" name="pdf" accept=".pdf" required class="file-input">
                    <button type="submit" name="upload" class="btn btn-primary">Upload PDF</button>
                </div>
            </form>
        </div>

        <div class="magazine-gallery">
            <h2>Your Magazines (<?php echo count($magazines); ?>)</h2>
            
            <?php if (empty($magazines)): ?>
                <div class="no-magazines">
                    <p>No magazines uploaded yet. Upload your first PDF above!</p>
                </div>
            <?php else: ?>
                <div class="magazine-grid">
                    <?php foreach ($magazines as $magazine): ?>
                        <div class="magazine-card">
                            <div class="magazine-thumbnail">📖</div>
                            <div class="magazine-info">
                                <h3><?php echo htmlspecialchars($magazine['title']); ?></h3>
                                <p>Size: <?php echo round($magazine['size'] / 1024 / 1024, 2); ?> MB</p>
                                <p>Uploaded: <?php echo date('M j, Y', $magazine['date']); ?></p>
                                <div class="magazine-actions">
                                    <a href="uploads/<?php echo urlencode($magazine['name']); ?>" 
                                       target="_blank" class="btn btn-primary">📖 View PDF</a>
                                    <a href="uploads/<?php echo urlencode($magazine['name']); ?>" 
                                       download class="btn btn-secondary">📥 Download</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="info-section">
            <h2>About This System</h2>
            <p>This is a simplified PDF magazine management system. Upload your PDF magazines and they'll be stored and organized for easy access.</p>
            
            <h3>Features:</h3>
            <ul>
                <li>✅ PDF file upload and storage</li>
                <li>✅ Magazine gallery with thumbnails</li>
                <li>✅ Direct PDF viewing in browser</li>
                <li>✅ Download functionality</li>
                <li>✅ Mobile responsive design</li>
                <li>✅ Works on basic shared hosting</li>
            </ul>

            <h3>Next Steps:</h3>
            <p>For advanced flipbook functionality with page-turning animations, additional server configuration would be needed. This version provides reliable PDF management that works on any hosting provider.</p>
        </div>

        <footer class="footer">
            <p>© 2025 FlipBook Magazine - Simple PDF Management System</p>
        </footer>
    </div>
</body>
</html>
